///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _HANDSHAKE_CPP
#define _HANDSHAKE_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedClasses/SQLClass/cSQL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"
#include "../../SharedClasses/CMemPool/CMemPool.H"
#include "../../SharedSource/SQLTemplate.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedSource/Debug.H"
#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/Common.H"
#include "../../SharedSource/CRC32.H"

#include "Init.H"
#include "Routines.H"
#include "HandShake.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsValidCompanyAccount(CSockSrvr *pSockSrvr, int iClient);
int IsValidClientVersion(CSockSrvr *pSockSrvr, int iClient, char *UpdateHTTPURL);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void BinPrint(const char *sData, int iLen)
{
	int iRPos = 0;
	while(iRPos < iLen)
	{
		printf("%X\n", sData[iRPos]);
		iRPos++;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	int PerformHandShake(int iClient, char *sRecvBuf, int iRecvBufSz)

	Performs a hand shake. Also know as Client/Server Authentication.

	Possible return Values:
		AUTH_FAILED   //The authentication process failed.
		AUTH_SUCCESS  //The authentication process was a success.
		AUTH_OK       //The authentication process is still in process, all is well.
		AUTH_ERROR    //The authentication process failed due to an error.
*/
int PerformHandShake(CSockSrvr *pSockSrvr, int iClient, char *sCmdBuf, int iCmdBufSz)
{
    char sCmdData[SENDBUFSZ + RECVBUFSZ];
    char sSendBuf[SENDBUFSZ + 1];
	char sTemp[SENDBUFSZ + RECVBUFSZ];

	int iSendBufSz = 0;
	int iCmdDataSz = 0;
	int iCmdFlagLength = 0;

    if((iCmdFlagLength = CmdCmp(sCmdBuf, "::AuthString->")))
    {
		if(CCI[iClient].dwAuthStep != 0)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication step.", EVENT_WARN);
			return AUTH_ERROR;
		}
		else CCI[iClient].dwAuthStep++;

		char sNewAuthKey_Crypt[MAX_KEY_LENGTH];
		char sNewAuthKey[MAX_KEY_LENGTH];

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		if(gbDebugMode)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Initializing Cryptography Set...", EVENT_NONE);
		}
		
		memset(&CCI[iClient].SC, 0, sizeof(CCI[iClient].SC));
		
		if(CCI[iClient].SC.InitializeCryptographyEx(gsAuthKey, strlen(gsAuthKey), true))
		{
			CCI[iClient].bIsEncryptionInit = true;
		}
		else{
			CCI[iClient].bIsEncryptionInit = false;
			WriteLogEx(pSockSrvr->icClientID[iClient], "Authentication failed due to failure to initialize cryptography.", EVENT_ERROR);
			return AUTH_ERROR;
		}

		CCI[iClient].SC.CipherEx(sCmdData, sTemp, iCmdDataSz);
		sTemp[iCmdDataSz] = '\0';

		if(gbDebugMode)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Received authentication string.", EVENT_NONE);
		}

		if(strcmp(sTemp, gsAuthString) != 0)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication String.", EVENT_WARN);
			pSockSrvr->SetNextSendData(iClient, "::AuthenticationFailed");
			return AUTH_FAILED;
		}
		
		if(gbDebugMode)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Validation of Authentication String verified.", EVENT_NONE);
		}
		
		if(!GenerateKey(gdwKeyGenLength, (GetTickCount()+iClient), GKUPPER_AZ|GKNUMBERS|GKNONREPETITION, sNewAuthKey))
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "PerformHandShake failed to generate a key.", EVENT_ERROR);
			pSockSrvr->SetNextSendData(iClient, "::AuthenticationFailed");
			return AUTH_ERROR;
		}

		CCI[iClient].SC.CipherEx(sNewAuthKey, sNewAuthKey_Crypt, gdwKeyGenLength);
		CCI[iClient].SC.DestroyCryptography();

		if(!CCI[iClient].SC.InitializeCryptographyEx(sNewAuthKey, gdwKeyGenLength, true))
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Failed to Initialize the cryptography set.", EVENT_ERROR);
		}

		iSendBufSz = AppendDataToCmd("::NewAuthKey->", sNewAuthKey_Crypt, gdwKeyGenLength, sSendBuf);
		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);

		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::NewKeyAuth->")))
    {
		if(CCI[iClient].dwAuthStep != 1)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication step.", EVENT_WARN);
			return AUTH_ERROR;
		}
		else CCI[iClient].dwAuthStep++;

		if(gbDebugMode)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Received new key Authentication string.", EVENT_NONE);
		}

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		CCI[iClient].SC.CipherEx(sCmdData, sTemp, iCmdDataSz);
		sTemp[iCmdDataSz] = '\0';

		if(strcmp(sTemp, gsAuthString) != 0)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid key.", EVENT_WARN);
			pSockSrvr->SetNextSendData(iClient, "::AuthenticationFailed");
			return AUTH_FAILED;
		}
		
		if(gbDebugMode)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Encryption key exchange complete.", EVENT_NONE);
		}

		pSockSrvr->SetNextSendData(iClient, "::RequestVersion");
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Version->")))
    {
		if(CCI[iClient].dwAuthStep != 2)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication step.", EVENT_WARN);
			return AUTH_ERROR;
		}
		else CCI[iClient].dwAuthStep++;

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		CCI[iClient].SC.Cipher(sCmdData, iCmdDataSz);
		sCmdData[iCmdDataSz] = '\0';

		strcpy_s(CCI[iClient].sClientVersion, sizeof(CCI[iClient].sClientVersion), sCmdData); // Save the client version.

		sprintf_s(sTemp, sizeof(sTemp), "Client Version: %s", sCmdData);
		WriteLogEx(pSockSrvr->icClientID[iClient], sTemp, EVENT_NONE);

		if(CCI[iClient].cIndexSQL.Connect(gsSQLIndexDriver, gsSQLIndexServer, gsSQLIndexUserID, gsSQLIndexPassword, gsSQLIndexDatabase, gsDBMode))
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Successfully connected to the Index database.", EVENT_NONE);
			CCI[iClient].bWPIndexConnected = true;
		}
		else{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Failed to connect to the Index database.", EVENT_ERROR);
			return AUTH_ERROR;
		}

        char sUpdateHTTPURL[1024 + 1];

        int iCVResult = IsValidClientVersion(pSockSrvr, iClient, sUpdateHTTPURL);
        if(iCVResult == CLIENTVER_CURRENT){
			if(gbDebugMode)
			{
				WriteLogEx(pSockSrvr->icClientID[iClient], "Client software is up-to-date.", EVENT_NONE);
			}
			pSockSrvr->SetNextSendData(iClient, "::RequestCompanyName");
            return AUTH_OK;
        }
        else if(iCVResult == CLIENTVER_SUPPORTED){
			WriteLogEx(pSockSrvr->icClientID[iClient], "Client software is outdated but still supported. Update soon!", EVENT_NONE);
			pSockSrvr->SetNextSendData(iClient, "::RequestCompanyName");
            return AUTH_OK;
        }
        else if(iCVResult == CLIENTVER_OUTDATED){
			WriteLogEx(pSockSrvr->icClientID[iClient], "Client software is outdated. Update now!", EVENT_NONE);
            return AUTH_ERROR;
        }
        else if(iCVResult == CLIENTVER_AUTOUPDATE){
			WriteLogEx(pSockSrvr->icClientID[iClient], "Performing client autoupdate.", EVENT_INFO);

            sprintf_s(sTemp, sizeof(sTemp), "::AutoUpdate->%s", sUpdateHTTPURL);
            pSockSrvr->SetNextSendData(iClient, sTemp);
            return AUTH_OK;
        }
        else{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Error verifing client version.", EVENT_ERROR);
            return AUTH_ERROR;
        }

		pSockSrvr->SetNextSendData(iClient, "::RequestCompanyName");
		return AUTH_ERROR;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::CompanyName->")))
    {
		if(CCI[iClient].dwAuthStep != 3)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication step.", EVENT_WARN);
			return AUTH_ERROR;
		}
		else CCI[iClient].dwAuthStep++;

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		CCI[iClient].SC.Cipher(sCmdData, iCmdDataSz);
		sCmdData[iCmdDataSz] = '\0';

		strcpy_s(CCI[iClient].sCompanyName, sizeof(CCI[iClient].sCompanyName), sCmdData); // Svae the company name;
	
		sprintf_s(sTemp, sizeof(sTemp), "Company Name: %s", sCmdData);
		WriteLogEx(pSockSrvr->icClientID[iClient], sTemp, EVENT_NONE);

		pSockSrvr->SetNextSendData(iClient, "::RequestPassword");
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Password->")))
    {
		CRecordSet rsExist;
		
		if(CCI[iClient].dwAuthStep != 4)
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication step.", EVENT_ERROR);
			return AUTH_ERROR;
		}
		else CCI[iClient].dwAuthStep++;

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		CCI[iClient].SC.Cipher(sCmdData, iCmdDataSz);
		sCmdData[iCmdDataSz] = '\0';

		strcpy_s(CCI[iClient].sPassword, sizeof(CCI[iClient].sPassword), sCmdData); // Svae the password;

		if(gbDebugMode)
		{
			sprintf_s(sTemp, sizeof(sTemp), "Password: %s", sCmdData);
			WriteLogEx(pSockSrvr->icClientID[iClient], sTemp, EVENT_NONE);
		}

        if(!IsValidCompanyAccount(pSockSrvr, iClient))
        {
			WriteLogEx(pSockSrvr->icClientID[iClient], "Invalid company account.", EVENT_WARN);
			pSockSrvr->SetNextSendData(iClient, "::AuthenticationFailed");
            return AUTH_FAILED;
        }

		//--------------------------------------------------------

		//Connect to the master database.
		if(CCI[iClient].cCustSQL.Connect(gsSQLCustDriver, gsSQLCustServer, gsSQLCustUserID, gsSQLCustPassword, "Master", gsDBMode))
		{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Successfully connected to the master database.", EVENT_NONE);
			CCI[iClient].bWPCustomerConnected = true;
		}
		else{
			WriteLogEx(pSockSrvr->icClientID[iClient], "Failed to connect to the master database.", EVENT_ERROR);
			return AUTH_FAILED;						
		}

		//--------------------------------------------------------

		WriteLogEx(pSockSrvr->icClientID[iClient], "Authentication success.", EVENT_NONE);
		pSockSrvr->SetNextSendData(iClient, "::AuthenticationSuccess");
		return AUTH_SUCCESS;
	}

	return AUTH_ERROR;	
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsValidCompanyAccount(CSockSrvr *pSockSrvr, int iClient)
{
    char sSQL[255];

	int iDataLength = 0;

	CRecordSet rsTemp;

	sprintf_s(sSQL, sizeof(sSQL), 
		"SELECT IsNull([Active], 0), IsNull([InitStep], -1), IsNull([CompDBPrefix], '')"
		" FROM [Companys]"
		" WHERE [CompName] = '%s' AND [CompPassword] = '%s'",
		CCI[iClient].sCompanyName, CCI[iClient].sPassword);

	if(!CCI[iClient].cIndexSQL.Execute(sSQL, &rsTemp))
    {
        WriteLogEx(pSockSrvr->icClientID[iClient], "Error in IsValidCompanyAccount :: Execute failed.", EVENT_ERROR);
        return false;
    }

    if(rsTemp.RowCount < 1) //No matching company name and password
	{
		rsTemp.Close();
		return false;
	}

	if(!rsTemp.Fetch())
    {
        WriteLogEx(pSockSrvr->icClientID[iClient], "Error in IsValidCompanyAccount :: DBFetch failed.", EVENT_ERROR);
        rsTemp.Close();
        return false;
    }

	if(iDataLength == -1)
	{
		WriteLogEx(pSockSrvr->icClientID[iClient], "Error in IsValidCompanyAccount :: DBGetData returned -1.", EVENT_ERROR);
		rsTemp.Close();
		return false;
	}

	//If the client active? (Enabled)
	if(rsTemp.lColumn(1) == 0)
	{
	    rsTemp.Close();
		return false;
	}

	CCI[iClient].iInitStep = rsTemp.lColumn(2);

	//If the client set to be initilized? If so, where do we start the replication?
	if(CCI[iClient].iInitStep > -1)
	{
		CCI[iClient].bRequestInit = true;
	}
	else {
		CCI[iClient].bRequestInit = false;
	}

	//If the client set to be initilized?
	if(!rsTemp.sColumnEx(3,
		CCI[iClient].sCompanyDBPrefix,
		sizeof(CCI[iClient].sCompanyDBPrefix),
		&iDataLength))
	{
	    WriteLogEx(pSockSrvr->icClientID[iClient],
			"Error in IsValidCompanyAccount :: Failed to get Company DB prefix.", EVENT_ERROR);
        rsTemp.Close();
        return false;
	}

	sprintf_s(sSQL, sizeof(sSQL), 
		"UPDATE [%s].[%s].[Companys] SET"
		" [IPAddress] = '%s',"
		" [LastConnect] = GetDate()"
		" WHERE [CompName] = '%s'",
		gsSQLIndexDatabase, gsDefaultDBO,
		CCI[iClient].sIPAddress, CCI[iClient].sCompanyName);

	CCI[iClient].cIndexSQL.ExecuteNonQuery(sSQL);

	rsTemp.Close();

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int IsValidClientVersion(CSockSrvr *pSockSrvr, int iClient, char *sUpdateHTTPURL)
{
    char sSQL[255];

	int iDataLength = 0;
    char ClientVersion[25 + 1];

	CRecordSet rsTemp;

	sprintf_s(sSQL, sizeof(sSQL), 
		"SELECT [Status], [UpdateURL]"
		" FROM [ClientVersions]"
		" WHERE [Version] = '%s'", CCI[iClient].sClientVersion);

	if(!CCI[iClient].cIndexSQL.Execute(sSQL, &rsTemp))
    {
		WriteLogEx(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: Execute failed.", EVENT_ERROR);
        return CLIENTVER_ERROR;
    }

    if(rsTemp.RowCount == 0)
    {
		WriteLogEx(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: Unknown client version.", EVENT_ERROR);

        rsTemp.Close();
        return CLIENTVER_ERROR;
    }

	rsTemp.Fetch();

    if(!rsTemp.sColumnEx(1, ClientVersion, 25, &iDataLength))
	{
		WriteLogEx(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: DBGetData 1 failed.", EVENT_ERROR);

        rsTemp.Close();
        return CLIENTVER_ERROR;
    }
	if(iDataLength > 0 && iDataLength <= 25)
	{
		ClientVersion[iDataLength] = '\0';
	}

	if(!rsTemp.sColumnEx(2, sUpdateHTTPURL, 1024, &iDataLength))
    {
		WriteLogEx(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: DBGetData 2 failed.", EVENT_ERROR);

        rsTemp.Close();
        return CLIENTVER_ERROR;
    }
	if(iDataLength > 0 && iDataLength <= 1024)
	{
		sUpdateHTTPURL[iDataLength] = '\0';
	}

    rsTemp.Close();

    if(_strcmpi((char *)ClientVersion, "current") == 0){ // Current version
        return CLIENTVER_CURRENT;
    }
    else if(_strcmpi((char *)ClientVersion, "supported") == 0){ // Old but supported
        return CLIENTVER_SUPPORTED;
    }
    else if(_strcmpi((char *)ClientVersion, "outdated") == 0){ // Old and nolonger supported
        return CLIENTVER_OUTDATED;
    }
    else if(_strcmpi((char *)ClientVersion, "autoupdate") == 0){ // Old and nolonger supported
        return CLIENTVER_AUTOUPDATE;
    }
    else{
		WriteLogEx(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: Unknown version identifier.", EVENT_ERROR);
        return CLIENTVER_ERROR;
    }

    return CLIENTVER_ERROR;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

